/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thecity;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.cards.blue.Defend_Blue;
import com.megacrit.cardcrawl.cards.green.Defend_Green;
import com.megacrit.cardcrawl.cards.green.Strike_Green;
import com.megacrit.cardcrawl.cards.red.Defend_Red;
import com.megacrit.cardcrawl.cards.red.Strike_Red;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardBrieflyEffect;

public class BackToBasics
extends AbstractImageEvent {
    public static final String ID = "Back to Basics";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Back to Basics");
    public static final String NAME = BackToBasics.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = BackToBasics.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = BackToBasics.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String DIALOG_2 = DESCRIPTIONS[1];
    private static final String DIALOG_3 = DESCRIPTIONS[2];
    private CUR_SCREEN screen = CUR_SCREEN.INTRO;

    public BackToBasics() {
        super(NAME, DIALOG_1, "images/events/backToBasics.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0]);
        GenericEventDialog.setDialogOption(OPTIONS[1]);
    }

    @Override
    public void update() {
        super.update();
        if (!AbstractDungeon.gridSelectScreen.selectedCards.isEmpty()) {
            AbstractCard c = AbstractDungeon.gridSelectScreen.selectedCards.get(0);
            AbstractDungeon.effectList.add(new PurgeCardEffect(c));
            AbstractDungeon.player.masterDeck.removeCard(c);
            AbstractDungeon.gridSelectScreen.selectedCards.remove(c);
        }
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                if (buttonPressed == 0) {
                    GenericEventDialog.updateBodyText(DIALOG_2);
                    this.logMetric("Elegance");
                    AbstractDungeon.gridSelectScreen.open(CardGroup.getGroupWithoutBottledCards(AbstractDungeon.player.masterDeck), 1, OPTIONS[2], false);
                    GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                    GenericEventDialog.clearRemainingOptions();
                } else {
                    GenericEventDialog.updateBodyText(DIALOG_3);
                    this.logMetric("Simplicity");
                    switch (AbstractDungeon.player.chosenClass) {
                        case IRONCLAD: {
                            this.simpleIronclad();
                            break;
                        }
                        case THE_SILENT: {
                            this.simpleSilent();
                            break;
                        }
                        case CROWBOT: {
                            this.simpleRobot();
                            break;
                        }
                    }
                    GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                    GenericEventDialog.clearRemainingOptions();
                }
                this.screen = CUR_SCREEN.COMPLETE;
                break;
            }
            case COMPLETE: {
                this.openMap();
            }
        }
    }

    private void simpleIronclad() {
        for (AbstractCard c : AbstractDungeon.player.masterDeck.group) {
            if (!(c instanceof Strike_Red) && !(c instanceof Defend_Red) || !c.canUpgrade()) continue;
            c.upgrade();
            AbstractDungeon.player.bottledCardUpgradeCheck(c);
            AbstractDungeon.effectList.add(new ShowCardBrieflyEffect(c.makeStatEquivalentCopy(), MathUtils.random(0.1f, 0.9f) * (float)Settings.WIDTH, MathUtils.random(0.2f, 0.8f) * (float)Settings.HEIGHT));
        }
    }

    private void simpleSilent() {
        for (AbstractCard c : AbstractDungeon.player.masterDeck.group) {
            if (!(c instanceof Strike_Green) && !(c instanceof Defend_Green) || !c.canUpgrade()) continue;
            c.upgrade();
            AbstractDungeon.player.bottledCardUpgradeCheck(c);
            AbstractDungeon.effectList.add(new ShowCardBrieflyEffect(c.makeStatEquivalentCopy(), MathUtils.random(0.1f, 0.9f) * (float)Settings.WIDTH, MathUtils.random(0.2f, 0.8f) * (float)Settings.HEIGHT));
        }
    }

    private void simpleRobot() {
        for (AbstractCard c : AbstractDungeon.player.masterDeck.group) {
            if (!(c instanceof Defend_Blue) || !c.canUpgrade()) continue;
            c.upgrade();
            AbstractDungeon.player.bottledCardUpgradeCheck(c);
            AbstractDungeon.effectList.add(new ShowCardBrieflyEffect(c.makeStatEquivalentCopy(), MathUtils.random(0.1f, 0.9f) * (float)Settings.WIDTH, MathUtils.random(0.2f, 0.8f) * (float)Settings.HEIGHT));
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CUR_SCREEN {
        INTRO,
        COMPLETE;

    }
}

